* CGK_Rawdata.do:
*  - generates expenditure aggregates from the detailed UCCs 
*  - generates unique household (CU) identifiers
*  - appends raw data to panel data MTAB, MEMB, FMLY
*
* Coibion-Gorodnichenko-Kueng; Initial version: March 2012.

**** NOTE: The raw data files are publicly available from ICPSR and are not provided here.



			********
			* MTAB * (Expenditure files)
			********

*** Prepare raw data

global data = "C:\Users\nfumi\Desktop\HANKempirical\InnocentBystandersreplication_folder\source_files\build files for CEX"
global home = "$data"
global savetype "saveold"

/*
cap n rm "$data/tempfiles/temp_exp.dta"
forvalues y=111(1)116 {
 forvalues q=1(1)4 {
  local yq=`y'`q'
  if `yq'>=1112 { // current start of sample
  display _n(1) "yq="`yq'

  * Append ITAB files since some expenditure UCCs are on the ITABS (e.g. occupational exp. before 2001Q1)
  use "$data/stata/itab`yq'.dta", clear
  ren value  cost
  ren value_ cost_
  $savetype "$data/tempfiles/temp_exp.dta", replace
  use "$data/stata/mtab`yq'.dta", clear
  append using "$data/tempfiles/temp_exp.dta"
  rename *, upper
  destring UCC, replace
  drop if UCC==. 
  * Generate expenditure aggregates 
  do "$home/do-files/MTABaggregation.do"
  * Generate top-coding indicators for the aggregate expenditures
  do "$home/do-files/MTABaggregation_topcoding.do"
  * Aggregate monthly UCC expenditures by household
  gen aaa=. // temporary variable for aorder below
  gen zzz=. // temporary variable for aord
  aorder
*  order intno
*  collapse (sum) aaa-zzz,by(NEWID intno REF_MO REF_YR)
  collapse (sum) aaa-zzz,by(NEWID REF_MO REF_YR)
  drop aaa zzz
   
  * Generate unique household identifier
  capture noisily: drop NEWIDunique  
  gen NEWIDunique=.
  if `yq'>=801&`yq'<821 {
    replace NEWIDunique=NEWID-100000
   }  
   else if `yq'>=821&`yq'<861 {
    replace NEWIDunique=NEWID-50000
   }
   else { //i.e. if `yq'>=861
   	capture destring NEWID, replace
    replace NEWIDunique=NEWID
  } // end if 
  
  * Sort and save data
  gen yq=`yq'
  order NEWID* REF_YR REF_MO yq 
  sort  NEWIDunique REF_YR REF_MO
  $savetype "$data/tempfiles/mt`yq'.dta", replace  
    
  * Survey Breaks in 1982Q1 1986Q1 1996Q1 20005Q1 
  if `yq'==821|`yq'==861|`yq'==961|`yq'==1051 {
   use "$data/stata/itab`yq'old.dta", clear
   capture: ren VALUE  COST
   capture: ren VALUE_ COST_
   $savetype "$data/tempfiles/temp_exp.dta", replace
   use "$data/stata/mtab`yq'old.dta", clear
   append using "$data/tempfiles/temp_exp.dta"
   drop if UCC==. 
   do "$home/do-files/MTABaggregation.do" 
   do "$home/do-files/MTABaggregation_topcoding.do"
   gen aaa=. 
   gen zzz=.
   aorder
   order intno
   collapse (sum) aaa-zzz,by(NEWID intno REF_MO REF_YR)
   drop aaa zzz
   capture noisily: drop NEWIDunique  
   gen NEWIDunique=.
   if `yq'>=801&`yq'<821 {
     replace NEWIDunique=NEWID-100000
    }  
    else if `yq'>=821&`yq'<861 {
     replace NEWIDunique=NEWID-50000
    }
    else { //i.e. if `yq'>=861
     replace NEWIDunique=NEWID
   } // end if 
   gen yq=`yq'
   order NEWIDunique
   order NEWID* REF_YR REF_MO yq 
   sort  NEWIDunique REF_YR REF_MO
   $savetype "$data/tempfiles/mt`yq'old.dta", replace
  } // end if survey break
 } // end if yq<maximum sample period
 } // end q
} // end y
cap n rm "$data/tempfiles/temp_exp.dta"


*** Append to monthly MTAB panel

clear
gen NEWIDunique=.
forvalues y=111(1)116 {
 forvalues q=1(1)4 {
  local yq=`y'`q'
  if `yq'>=1112 { // current start of sample
  display _n(1) "yq="`yq'
  append using "$data/tempfiles/mt`yq'.dta"
  * Survey breaks
  if `yq'==821|`yq'==861|`yq'==961|`yq'==1051 {
   di _n(1) "survey break in `yq'"_n(1)
   * Merge FMLY files to obtain list of valid CUs (i.e. consistent identifiers across sample break)
   sort NEWIDunique intno
   $savetype "$data/stata/MTAB.dta", replace
   use "$data/tempfiles/mt`yq'old.dta", clear
   merge m:1 NEWID intno using "$data/stata/fmly`yq'old2.dta", keepusing(NEWID intno)
   tab _merge
   keep if _merge==3
   drop _merge
   append using "$data/stata/MTAB.dta", force
  } // end if
 } // end if yq<maximum sample period
 } // end q
} // end y
aorder
order NEWIDunique NEWID REF_YR REF_MO yq

destring REF_YR,replace
destring REF_MO,replace
gen date=ym(REF_YR,REF_MO)
format date %tm
label var date "month of expenditure"
order date ,before(REF_YR)

tab date
drop if date<m(1979m10)

gen QINTRVYR=round(yq/10)+1900
gen q=((yq/10+1900)-QINTRVYR)*10
gen intdateQ=yq(QINTRVYR,q)
format intdateQ %tq
label var intdateQ "quarter of interview"
drop q
order QINTRVYR intdateQ,after(yq)

compress
sort NEWIDunique REF_YR REF_MO
label data "MTAB panel: raw data"
$savetype "$data/stata/MTABnew.dta", replace




















			********
			* MEMB * (MEMBer characteristics and income)
			********
/* 
- Construct consistent time series of family income (FMLY files) by aggregating over individual household members (MEMB files). 
		Note: This is necessary since these FMLY income and tax variables have sample breaks, and the BLS imputes missing values of those income variables (implicitly) with zeros.
- Also add MEMB variables needed for TAXSIM calculator.
*/

*** Prepare raw data and append to panel 
	
cap n rm "$data/tempfiles/temp_inc.dta"
clear
forvalues y=111(1)116 {
 forvalues q=1(1)4 {
  local yq=`y'*10+`q'  
  if `yq'>=1112 { // current start of sample
  display `yq'
  
  * load data
  preserve
  use "$data/stata/memb`yq'.dta",clear
  rename *, upper
  capture destring NEWID, replace
  * create unique household identifier
  gen NEWIDunique = NEWID
  if `yq'<821 {
    replace NEWIDunique = NEWID-100000
  }
  else if `yq'>=821 & `yq'<861 {
    replace NEWIDunique = NEWID- 50000
  }
  if `yq'==821 | `yq'==861 | `yq'==961 | `yq'==1051 { // dealing with survey breaks in 1982Q1, 1986Q1, 1996Q1, 2005Q1
   append using "$data/stata/memb`yq'old2.dta" ,force
   if `yq'==821 {
    replace NEWIDunique = NEWID-100000 if NEWIDunique==.
   }
   else if `yq'==861 {
    replace NEWIDunique = NEWID- 50000 if NEWIDunique==.
   }
   else {
    replace NEWIDunique = NEWID        if NEWIDunique==.
   }
  }
  
  * replace valid blanks with zeros (i.e. if flag label equals "A")
  gen yq=`yq' // there is no date variable on the MEMB files
  di `yq'
  do "$home/do-files/MEMBvalidblank.do"
    
  * correct top-coded SALARYX that is set to 0 instead of the critical value (only in 1980/81)
  if `yq'<821 {
    qui: sum SALARYX
    local max=`r(max)'
    replace SALARYX=`max' if SALARYX_=="T" & SALARYX!=`max'
  }
  
  * create RAW SERIES of FMLY incomes aggregated from MEMB files by summing over all HH members
  bysort NEWIDunique: egen FSALARYXr = sum(SALARYX)
  capture bysort NEWIDunique: egen FNONFRMXr = sum(NONFARMX)
  capture bysort NEWIDunique: egen FFRMINCXr = sum(FARMINCX)
  bysort NEWIDunique: egen FRRETIRXr = sum(SOCRRX)
  bysort NEWIDunique: egen FSSIXr    = sum(SSIX)
  capture bysort NEWIDunique: egen FAMTFEDXr = sum(ANFEDTX)
  capture bysort NEWIDunique: egen FSLTAXXr  = sum(ANSLTX)
  
  * create BRACKETED SERIES of FMLY incomes aggregated from MEMB files by summing over all HH members (bracketing starts in 2001Q2)
  if `yq'<961 {
   gen SALARYBX =.
   gen NONFRMBX =.
   gen FRMINCBX =.
   gen SSIBX    =.  
  }
  if `yq'<1012 {
   gen SOCRRBX  =.
   gen FSALARYXb =. 
   gen FNONFRMXb =.
   gen FFRMINCXb =.
   gen FRRETIRXb =.
   gen FSSIXb    =.
  }
  if `yq'>=1012 {
                       gen  SOCRRBX   = SOCRRX if RRRETIRI==301 // Note: SOCRRX does not have a bracketed variable nor an imputation indicator. However we can use the imputation indicator RRRETIRI instead.
   bysort NEWIDunique: egen FSALARYXb = sum(SALARYBX)
   capture bysort NEWIDunique: egen FNONFRMXb = sum(NONFRMBX)
   capture bysort NEWIDunique: egen FFRMINCXb = sum(FRMINCBX)
   bysort NEWIDunique: egen FRRETIRXb = sum(SOCRRBX)
   bysort NEWIDunique: egen FSSIXb    = sum(SSIBX)
  }
   
  * create IMPUTED SERIES of FMLY incomes aggregated from MEMB files by summing over all HH members
  if `yq'< 1041 {
   gen FSALARYXm = .
   gen FNONFRMXm = .
   gen FFRMINCXm = .
   gen FRRETIRXm = .
   gen FSSIXm    = .
  }
  if `yq'>=1041 {
   bysort NEWIDunique: egen FSALARYXm = sum(SALARYXM)
   capture bysort NEWIDunique: egen FNONFRMXm = sum(NONFARMM)
   capture bysort NEWIDunique: egen FFRMINCXm = sum(FARMINCM)
   bysort NEWIDunique: egen FRRETIRXm = sum(SOCRRXM)
   bysort NEWIDunique: egen FSSIXm    = sum(SSIXM)
  }

  * create IMPUTATION INDICATOR for invalid blanks that have to be imputed later
  bysort NEWIDunique: egen FSALARYXimp = sum(SALARYX==.)
  capture bysort NEWIDunique: egen FNONFRMXimp = sum(NONFARMX==.)
  capture bysort NEWIDunique: egen FFRMINCXimp = sum(FARMINCX==.)
  bysort NEWIDunique: egen FRRETIRXimp = sum(SOCRRX==.)
  bysort NEWIDunique: egen FSSIXimp    = sum(SSIX==.)
  capture bysort NEWIDunique: egen FAMTFEDXimp = sum(ANFEDTX==.)
  capture bysort NEWIDunique: egen FSLTAXXimp  = sum(ANSLTX==.)
   
  * keep variables of interest
*  cap rename INTNO intno
*  keep NEWIDunique intno MEMBNO yq ///
  keep NEWIDunique MEMBNO yq ///
  FSALARY* FNONFRM* FFRMINC* FRRETIR* FSSI* FAMTFED* FSLTAXX* /// family income aggregates
       SALARYX  NONFARMX FARMINCX SOCRRX   SSIX  ANFEDTX  ANSLTX   INDRETX CU_CODE AGE IN_COLL /// TAXSIM  inputs 
       SALARYBX NONFRMBX FRMINCBX SOCRRBX  SSIBX
  
  
  * append data
  $savetype "$data/tempfiles/temp_inc.dta",replace
  restore
  append using "$data/tempfiles/temp_inc.dta", force
 } // end if yq<maximum sample period
 } // end q
} // end y
cap n rm "$data/tempfiles/temp_inc.dta"
compress
sort NEWIDunique MEMBNO
label data "MEMB panel (raw data)"
$savetype "$data/stata/MEMBnew.dta", replace
*/














			********
			* FMLY * (FaMiLY characteristics and income)
			********

*** Prepare raw data and append to panel 

cap n rm "$data/tempfiles/temp_inc.dta"
clear
gen yq=.
forvalues y=111(1)116 {
 forvalues q=1(1)4 {
  local yq=`y'*10+`q'  
  if `yq'>=1112 { // current start of sample
  display `yq'
  
  * load data
  preserve
  
  *-----------------------------------------------------------------------------  
  use "$data/stata/fmly`yq'.dta",clear
  rename *, upper
  * create unique household identifier
  capture destring NEWID, replace
  gen NEWIDunique = NEWID
  if `yq'<821 {
    replace NEWIDunique = NEWID-100000
  }
  else if `yq'>=821 & `yq'<861 {
    replace NEWIDunique = NEWID- 50000
  }
  if `yq'==821 | `yq'==861 | `yq'==961 | `yq'==1051 { // dealing with survey breaks in 1982Q1, 1986Q1, 1996Q1, 2005Q1
   append using "stata/fmly`yq'old2.dta" ,force
   if `yq'==821 {
    replace NEWIDunique = NEWID-100000 if NEWIDunique==.
   }
   else if `yq'==861 {
    replace NEWIDunique = NEWID- 50000 if NEWIDunique==.
   }
   else {
    replace NEWIDunique = NEWID        if NEWIDunique==.
   }
  }
  
  * replace valid blanks with zeros (i.e. if flag lable ="A")
  do "$home/do-files/FMLYvalidblank.do"
  
  * dealing with bracketed variables, which are missing at the beginning
  if `yq'< 1012 {
  #delim;
  cap:drop UNEMPLBX; gen UNEMPLBX =.; 
  cap:drop COMPNSBX; gen COMPNSBX =.; 
  cap:drop WELFREBX; gen WELFREBX =.; 
  cap:drop INTERNBX; gen INTERNBX =.; 
  cap:drop FININCBX; gen FININCBX =.; 
  cap:drop PNSIONBX; gen PNSIONBX =.; 
  cap:drop INCLSABX; gen INCLSABX =.; 
  cap:drop INCLSBBX; gen INCLSBBX =.; 
  cap:drop ALIOTHBX; gen ALIOTHBX =.; 
  cap:drop CHDOTHBX; gen CHDOTHBX =.; 
  cap:drop INCCONBX; gen INCCONBX =.; 
  cap:drop OTRINCBX; gen OTRINCBX =.; 
  cap:drop FOODSPBX; gen FOODSPBX =.; 
  #delim cr
  }

  * dealing with variables that change over time
  if `yq'< 1012 {
   capture noisily: gen FOODSMPX=.
   replace FOODSMPX = JFDSTMPA // name of food stamps variable changes in 2001Q2 from JFDSTMPA to FOODSMPX
  }
  if `yq'> 932 {
   cap: drop INCCONTX 
   cap: drop INCCONBX
   capture gen INCCONTX = ALIOTHX+CHDOTHX // contributions from alimony and child support
   capture gen INCCONBX = ALIOTHBX+CHDOTHBX
  }
  if `yq'>= 841 & `yq'< 881 {
   cap: gen MISCTAXX =.
   replace MISCTAXX = JOTAXNET // property and other taxes not reported elsewhere
  }
  
  di `yq'
  foreach var in ALIOTHX ALIMOX INDRETX COLLEXPX CNTRCHRX CNTEDORX CNTRELGX { //  variables not available in all years
    capture noisily: qui sum `var'
    if _rc!=0 { 
     gen `var'=. // if variable not in data set
    }
  }
    
  * select variables of interest
*  keep NEWIDunique intno QINTRVMO QINTRVYR FINLWT21 RESPSTAT ///
  keep NEWIDunique QINTRVMO QINTRVYR FINLWT21 RESPSTAT ///
  FAM_SIZE PERSLT18 PERSOT64 NO_EARNR /// family level covariates
  AGE_REF SEX_REF REF_RACE EDUC_REF INCWEEK1 INC_HRS1 /// refernce person covariates
  AGE2    SEX2    RACE2    EDUCA2   INCWEEK2 INC_HRS2 /// spouse covariates
  UNEMPLX  COMPENSX WELFAREX INTEARNX FININCX  PENSIONX INCLOSSA INCLOSSB OTHRINCX FOODSMPX INCCONTX FEDTAXX SLOCTAXX TAXPROPX FEDRFNDX SLRFUNDX MISCTAXX OTHRFNDX /// raw variables
  UNEMPLBX COMPNSBX WELFREBX INTERNBX FININCBX PNSIONBX INCLSABX INCLSBBX OTRINCBX FOODSPBX INCCONBX /// bracketed variables  
  ALIOTHX SALEINCX SETLINSX LUMPSUMX SSOVERPX INSRFNDX COLLEXPX ALIMOX PTAXRFDX TAXPROPX CNTRCHRX CNTEDORX CNTRELGX FINDRETX STATE MARITAL1 /// additional variables needed for TAXSIM
  OCCU* INCOMEY* INCNONW* /// occupation and industry variables
  FINCBTAX FINCATAX FSALARYX FNONFRMX FFRMINCX FRRETIRX FSSIX FAMTFEDX FSLTAXX // aggregate family income (for comparison)

  drop OCCU_* // drop occuption flags

  * append data
  $savetype "$data/tempfiles/temp_inc.dta", replace
  *-----------------------------------------------------------------------------
  
  restore  
  append using "$data/tempfiles/temp_inc.dta"  
  replace yq=`yq' if yq==.
 } // end if yq<maximum sample period
 } // end q
} // end y
cap n rm "$data/tempfiles/temp_inc.dta"

* combine raw and bracketed series
capture gen     UNEMPLXrb  = UNEMPLX
capture replace UNEMPLXrb  = UNEMPLBX if (UNEMPLX==. |UNEMPLX==0)  & UNEMPLBX!=.
capture gen     COMPENSXrb = COMPENSX
capture replace COMPENSXrb = COMPNSBX if (COMPENSX==.|COMPENSX==0) & COMPNSBX!=.
gen     WELFAREXrb = WELFAREX
replace WELFAREXrb = WELFREBX if (WELFAREX==.|WELFAREX==0) & WELFREBX!=.
capture gen     INTEARNXrb = INTEARNX
capture replace INTEARNXrb = INTERNBX if (INTEARNX==.|INTEARNX==0) & INTERNBX!=.
capture gen     FININCXrb  = FININCX
capture replace FININCXrb  = FININCBX if (FININCX==. |FININCX==0)  & FININCBX!=.
capture gen     PENSIONXrb = PENSIONX
capture replace PENSIONXrb = PNSIONBX if (PENSIONX==.|PENSIONX==0) & PNSIONBX!=.
capture gen     INCLOSSArb = INCLOSSA
capture replace INCLOSSArb = INCLSABX if (INCLOSSA==.|INCLOSSA==0) & INCLSABX!=.
capture gen     INCLOSSBrb = INCLOSSB
capture replace INCLOSSBrb = INCLSABX if (INCLOSSB==.|INCLOSSB==0) & INCLSABX!=.
capture gen     OTHRINCXrb = OTHRINCX
capture replace OTHRINCXrb = OTRINCBX if (OTHRINCX==.|OTHRINCX==0) & OTRINCBX!=.
capture gen     FOODSMPXrb = FOODSMPX
capture replace FOODSMPXrb = FOODSPBX if (FOODSMPX==.|FOODSMPX==0) & FOODSPBX!=.
capture gen     INCCONTXrb = INCCONTX
capture replace INCCONTXrb = INCCONBX if (INCCONTX==.|INCCONTX==0) & INCCONBX!=.

* create interview month
destring QINTRVYR QINTRVMO, replace
gen intdate=ym(QINTRVYR, QINTRVMO)
label var intdate "Date of interview"
format intdate %tm

destring EDUC_REF EDUCA2, replace
* make education variable consistent
replace EDUC_REF =7 if intdate>=m(1996m1) & EDUC_REF==0   // never attended school
replace EDUC_REF =1 if intdate>=m(1996m1) & EDUC_REF==10  // elementary school (1-8 yrs)
replace EDUC_REF =2 if intdate>=m(1996m1) & EDUC_REF==11  // high school drop-out (1-4yrs)
replace EDUC_REF =3 if intdate>=m(1996m1) & EDUC_REF==12  // high school graduate (4 yrs)
replace EDUC_REF =4 if intdate>=m(1996m1) &(EDUC_REF==13|EDUC_REF==14) // college drop-out (1-4yrs). Alternatively: 13 = Some college, less than college graduate; 14 = associate's degree (occupational/vocational or academic)
replace EDUC_REF =5 if intdate>=m(1996m1) & EDUC_REF==15  // college graduate (4 yrs)
replace EDUC_REF =6 if intdate>=m(1996m1) &(EDUC_REF==16|EDUC_REF==17) // more than 4 yrs of college. Alternatively: 16 = Master's degree; 17 = Professional/Doctorate degree
replace EDUCA2 =7 if intdate>=m(1996m1) & EDUCA2==0
replace EDUCA2 =1 if intdate>=m(1996m1) & EDUCA2==10
replace EDUCA2 =2 if intdate>=m(1996m1) & EDUCA2==11
replace EDUCA2 =3 if intdate>=m(1996m1) & EDUCA2==12
replace EDUCA2 =4 if intdate>=m(1996m1) &(EDUCA2==13|EDUCA2==14)
replace EDUCA2 =5 if intdate>=m(1996m1) & EDUCA2==15 
replace EDUCA2 =6 if intdate>=m(1996m1) &(EDUCA2==16|EDUCA2==17)


* create consistent occupation indicator

gen incomey1=INCOMEY1 // consistent INCOMEY: type of main employer
destring incomey1, replace
recode incomey1 (2=24)(3=5)(4=6) if yq<=841
label var incomey1 "Type of employer of reference person (consistent series)" 
gen incomey2=INCOMEY2 // consistent INCOMEY variables
destring incomey2, replace
recode incomey2 (2=24)(3=5)(4=6) if yq<=841
label var incomey2 "Type of employer of spouse (consistent series)" 
/*
1  Private company, business or individual
2  Federal government (from 1984Q2 on)
3  State government (from 1984Q2 on)
4  Local government (from 1984Q2 on)
5  Self-employed in own business, professional practice or farm
6  Family business or farm, working without pay
24 Government employee, i.e. combining 2-4 above.
*/

gen incnonw1=INCNONW1 // consistent INCNONW: reason for not working
destring incnonw1, replace
recode incnonw1 (1=4)(4=5)(5=1) if yq<=934
label var incnonw1 "reason reference person did not work (consistent series)"
gen incnonw2=INCNONW2 // consistent INCNONW: reason for not working
destring incnonw2, replace
recode incnonw2 (1=4)(4=5)(5=1) if yq<=934
label var incnonw2 "reason spouse did not work (consistent series)"
/*
1  Retired
2  Taking care of home/family
3  Going to school
4  Ill, disabled, unable to work
5  Unable to find work
6  Doing something else
*/

gen occucod1=OCCUCOD1 // consistent OCCUCOD and OCCUPRE: occupation
destring occucod1, replace
recode  occucod1 (1/3=1)(4/7=2)(8/10=3)(16/17=4)(14/15=5)(11/13=6)(18=7)
replace occucod1=8  if incomey1==5               & occucod1==. & yq>=941 // self-employed [Note: doesn't match OCCUPRE1 exactly, hence has measurement error)
replace occucod1=9  if incnonw1!=1 & incnonw1!=. & occucod1==. & yq>=941 // not working
replace occucod1=10 if incnonw1==1               & occucod1==. & yq>=941 // retired
replace occucod1=11 if incomey1==6               & occucod1==. & yq>=941 // working without pay, but not in occupations 1-7 => ~ other [Note: some small measurement error (12 out of 203) based on test sample of OCCUPRE1 up to 1993Q4.
capture replace occucod1=OCCUPRE1 if yq<=934 & occucod1==.
label var occucod1 "occupation of reference person (consistent series)"
gen occucod2=OCCUCOD2
destring occucod2, replace
recode  occucod2 (1/3=1)(4/7=2)(8/10=3)(16/17=4)(14/15=5)(11/13=6)(18=7)
replace occucod2=8  if incomey2==5               & occucod2==. & yq>=941 // self-employed [Note: doesn't match OCCUPRE1 exactly, hence has measurement error)
replace occucod2=9  if incnonw2!=1 & incnonw2!=. & occucod2==. & yq>=941 // not working
replace occucod2=10 if incnonw2==1               & occucod2==. & yq>=941 // retired
replace occucod2=11 if incomey2==6               & occucod2==. & yq>=941 // working without pay, but not in occupations 1-7 => ~ other [Note: some small measurement error (12 out of 203) based on test sample of OCCUPRE1 up to 1993Q4.
capture replace occucod2=OCCUPRE2 if yq<=934 & occucod2==.
label var occucod2 "occupation of spouse (consistent series)"
/*
01  Managerial & professional specialty 
02  Technical, sales, and administrative support
03  Service 
04  Farming, forestry, and fishing 
05  Precision production, craft, and repair 
06  Operators, fabricators, and laborers 
07  Armed forces 
08  Self-employed (NOTE: Not available after 1993Q4)
09  Not working 
10  Retired 
11  Other, including not reported (NOTE: Not available after 1993Q4)
*/


* label variables
label var NEWIDunique "unique household identifier"
*label var intno    "interview number"
label var QINTRVMO "interview month"
label var QINTRVYR "interview year"
label var FINLWT21 "BLS sample weight"
capture label var RESPSTAT "complete income reporter: 1=year, 2=no"
label var FAM_SIZE "family size"
label var PERSLT18 "# of persons less than 18 years"
label var PERSOT64 "# of persons over 64 years"
label var NO_EARNR "# of earners"
label var AGE_REF  "age of reference person"
label var SEX_REF  "gender of reference person: 1=male, 2=female" 
label var REF_RACE "race of reference person: 1=white, 2=black, 3=native american, 4=asian, 5=pacific islander, 6=multi-race"
label var EDUC_REF "education level of reference person" 
label var INCWEEK1 "# of weeks worked in previous year (full or part time) by reference person"
label var INC_HRS1 "# of hours worked in typical week by reference person" 
label var AGE2     "age of spouse"
label var SEX2     "gender of spouse: 1=male, 2=female"
label var RACE2    "race of spouse: 1=white, 2=black, 3=native american, 4=asian, 5=pacific islander, 6=multi-race"
label var EDUCA2   "education level of spouse"
label var INCWEEK2 "# of weeks worked in previous year (full or part time) by spouse"
label var INC_HRS2 "# of hours worked in typical week by spouse"


* drop variables that are not needed anymore
drop *BX // bracketed variables
drop OCCU* INCOMEY* INCNONW* // variables used to construct occucode1,2


* save data
gen fwt=round(FINLWT21)
label var fwt "final sample weight [integers of FINLWT21]"
*order NEWIDunique intno intdate
*sort  NEWIDunique intno
order NEWIDunique intdate
sort  NEWIDunique 
compress
label data "FaMiLY characteristics and income (FMLY) variables for Coibion-Gorodnichenko-Kueng"
$savetype "$data/stata/FMLYnew.dta" ,replace
*/

